<?php

namespace App\Listeners;

use App\Events\JobPosted;
use App\Models\User;
use App\Models\Notification;
use Illuminate\Support\Facades\Broadcast;
use Illuminate\Support\Facades\DB;

class SendJobPostedNotification
{
    public function handle(JobPosted $event)
    {
        // Fetch User_ids where Role_id is 3 (candidates)
        $candidateRoleId = 3; // Assuming Role_id 3 is for candidates
        $candidateUserIds = DB::table('user_roles')
            ->where('Role_id', $candidateRoleId)
            ->pluck('User_id');

        $candidates = User::whereIn('User_id', $candidateUserIds)->get();

        foreach ($candidates as $candidate) {
            // Create a notification record
            Notification::create([
                'User_id' => $candidate->User_id,
                'Title' => 'New Job Posted',
                'Message' => 'A new job titled "' . $event->job->Title . '" has been posted by ' . $event->job->company->Company_name,
                'Type' => 'info',
                'Is_read' => false,
            ]);

            // Broadcast to candidates (frontend should listen on 'jobs' channel)
            broadcast(new \Illuminate\Broadcasting\BroadcastEvent(
                'JobPosted',
                ['job' => $event->job->only(['Job_id', 'Title', 'Description', 'Company_id']), 'user_id' => $candidate->User_id]
            ));
        }
    }
}
